/*
 * Copyright 2019 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _GTOF_UTILS_H_
#define _GTOF_UTILS_H_

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                      Includes Section
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <fsl_common.h>


/*!
 * @addtogroup GENFSK_Localization
 * @addtogroup TimeOfFlight Time of Flight localization feature
 * @ingroup GENFSK_Localization
 * @{
 */

/*! @file
 * GENFSK Localization - Time of Flight utils API
 */

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Defines & Macros Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                      Typedef Section
///////////////////////////////////////////////////////////////////////////////////////////////////

typedef int32_t fixedq6_t;

typedef int32_t fixedq8_t;

typedef int32_t fixedq16_t;

typedef int64_t fixedq6i64_t;

typedef struct lfsr_ {
    uint8_t seed;
    uint8_t lfsr;
} lfsr_t;

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                Function-like Macros Section
///////////////////////////////////////////////////////////////////////////////////////////////////

#define INTEGER_TO_FIXED_Q8(X)             ((X) << 8U)

#define INTEGER_TO_FIXED_Q6(X)             ((X) << 6U)

#define FIXED_Q6_TO_FIXED_Q8(X)            ((X) << 2U)

#define FIXED_Q8_TO_FIXED_Q6(X)            ((X) >> 2U)

#define INTEGER_FROM_FIXED_Q8(X)           ((X) >> 8U)

#define INTEGER_FROM_FIXED_Q6(X)           ((X) >> 6U)

#define INTEGER_TO_FIXED_Q16(X)            ((X) << 16U)

#define INTEGER_FROM_FIXED_Q16(X)          ((X) >> 16U)

#define FIXED_GET_FRACTION_Q8(X)           (((((X)&0xFFu)*1000u)+128u) >> 8u)

#define FIXED_GET_FRACTION_Q6(X)           (((((X)&0x3Fu)*1000u)+32u) >> 64u)

#define FIXED_GET_INTEGER_Q8(X)            ((X) >> 8U)

#define FIXED_GET_INTEGER_Q6(X)            ((X) >> 6U)

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Extern Constants Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                  Extern Variables Section
///////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////
//                                Function Prototypes Section
///////////////////////////////////////////////////////////////////////////////////////////////////

#if defined(__cplusplus)
extern "C" {
#endif // __cplusplus

void LfsrInit(lfsr_t *newLfsr, uint8_t seed);
void LfsrInitSequence(lfsr_t *currentLfsr);
void LfsrGetNumber(lfsr_t *currentLfsr, uint8_t * newNumber);

fixedq6_t FixedPointQ6Division(fixedq6_t dividend, fixedq6_t divisor);
fixedq6_t FixedPoint_Q6DivisionI64(fixedq6i64_t dividend, fixedq6_t divisor);

#if defined(__cplusplus)
}
#endif // __cplusplus

/*! @} */

#endif /* _H_ */
///////////////////////////////////////////////////////////////////////////////////////////////////
// EOF
///////////////////////////////////////////////////////////////////////////////////////////////////
